<?php
header('Access-Control-Allow-Origin: *');
header('Content-Type: application/json');

include 'db.php';
include 'authorization.php';
include 'functions.php';

// Get the raw POST data
$rawData = file_get_contents('php://input');

// Decode JSON data
$data = json_decode($rawData, true);

if (!$data) {
    echo json_encode(["message" => "Invalid JSON data received"]);
    exit();
}

// Validate required fields
if (empty($data['uID'])) {
    echo json_encode(["message" => "Missing required field: uID"]);
    exit();
}

$uID = $data['uID'];
$isLearner = $data['isLearner'];

if($isLearner==false || $isLearner=="false"){
    $query = " SELECT users.name, session_details.test_result_id, test_results.learnerID AS learnerID, session_details.session_date, 
       users.city, session_details.slot_one, session_details.slot_two, session_details.slot_three, users.uID,
       session_details.accepted_one, session_details.accepted_two, session_details.accepted_three
FROM session_details 
INNER JOIN users ON session_details.uID = users.uID 
INNER JOIN (SELECT learnerID, id FROM test_results) AS test_results 
    ON test_results.id = session_details.test_result_id 
WHERE users.uID = '$uID'";
}else{
    $query = " SELECT users.name, session_details.test_result_id, test_results.learnerID AS learnerID, session_details.session_date, 
       users.city, session_details.slot_one, session_details.slot_two, session_details.slot_three, users.uID,
       session_details.accepted_one, session_details.accepted_two, session_details.accepted_three
FROM session_details 
INNER JOIN users ON session_details.uID = users.uID 
INNER JOIN (SELECT learnerID, id FROM test_results) AS test_results 
    ON test_results.id = session_details.test_result_id 
WHERE test_results.learnerID = '$uID'";
}


// Query to fetch data from the database based on uID


$result = mysqli_query($conn, $query);
if (!$result) {
    echo json_encode(["message" => "Error executing query"]);
    exit();
}

if (mysqli_num_rows($result) > 0) {
    $responseData = [];
    $entries=[];
    while ($row = mysqli_fetch_assoc($result)) {
        $slot_one=$row['slot_one'];
        $slot_two=$row['slot_two'];
        $slot_three=$row['slot_three'];
        $accepted_one=$row['accepted_one'];
        $accepted_two=$row['accepted_two'];
        $accepted_three=$row['accepted_three'];
        $uID=$row['uID'];
        if($slot_one){
            if($accepted_one=='No'){
                try {
    $slot_one = convert24HourTo12Hour($slot_one);
} catch (Exception $e) {
}
        $entries[] = [
            "uID" => $uID,
            "learnerID" => $row['learnerID'],
            "learnerName" => $row['name'],
            "sessiontime" => $slot_one,
            "date" => $row['session_date'],
            "city" => $row['city']
        ];
            }
        }
        if($slot_two){
            if($accepted_two=='No'){
                try {
    $slot_two = convert24HourTo12Hour($slot_two);
} catch (Exception $e) {
}
        $entries[] = [
            "uID" => $uID,
            "learnerID" => $uID,
            "learnerID" => $row['learnerID'],
            "sessiontime" => $slot_two,
            "date" => $row['session_date'],
            "city" => $row['city']
        ];
            }
        }
        if($slot_three){
            if($accepted_three=='No'){
         try {
    $slot_three = convert24HourTo12Hour($slot_three);
} catch (Exception $e) {
}       
        $entries[] = [
            "uID" => $uID,
            "learnerID" => $uID,
            "learnerID" => $row['learnerID'],
            "sessiontime" => $slot_three,
            "date" => $row['session_date'],
            "city" => $row['city']
        ];
        }
        }
    }
    if (empty($entries)) {
   echo json_encode(["message" => "You have no active request"]);
}else{
$responseData = [
                "message" => "Success Message!", 
                "data" => $entries
            ];

    echo json_encode($responseData);
}
} else {
    echo json_encode(["message" => "Currently you have no requests"]);
}
mysqli_close($conn);
?>
